import mfrc522

# Initialisation du lecteur de badge
SCK = 18   # GPIO18 (VSPI_CLK)
MOSI = 23  # GPIO 23 (VSPI_MOSI)
MISO = 19  # GPIO19 (VSPI_MISO)
RST = 4    # GPIO4
NSS = 5     # GPIO5 (VSPI_CS)

rdr = mfrc522.MFRC522(SCK, MOSI, MISO, RST, NSS)

def lire_uid_RFID():
    """renvoie l'uid  du badge lu
    raw_uid : liste de 5 octets"""
    
    print("Placer le badge ou la carte")
    (stat, tag_type) = rdr.request(rdr.REQIDL)
    while stat != rdr.OK: # attente du placement du badge
        (stat, tag_type) = rdr.request(rdr.REQIDL)
    if stat == rdr.OK:  # si stat == 0 (badge présent)
        (stat, raw_uid) = rdr.anticoll()  # lecture du raw_uid
        print("Badge ou carte détecté")
    return raw_uid


def decimal_list_to_hex(decimal_list):
    """renvoie la conversation d'une liste de chiffre décimaux en chaine de caractère de chiffre hexadécimal"""
    return ' '.join([hex(num)[2:].upper() for num in decimal_list])
